clear; %removes all variables from the workspace

ft = linspace(0,5,25); % Generate t for f
f = ft.^2 - ft - 3; % Generate f(t)

Tspan = [1 5]; % Solve from t=1 to t=5
IC = 1; % y(t=0) = 1
[T Y] = ode45(@(t,y) myode2(t,y,ft,f),Tspan,IC); % Solve ODE

plot(T, Y);
title('Plot of y as a function of time');
xlabel('Time'); ylabel('Y(t)');